/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_327;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public abstract class IotaType<T extends Iota> {
    @javax.annotation.Nullable
    public abstract T deserialize(class_2520 var1, class_3218 var2) throws IllegalArgumentException;

    public abstract class_2561 display(class_2520 var1);

    public abstract int color();

    public class_2561 typeName() {
        class_2960 key = HexIotaTypes.REGISTRY.method_10221((Object)this);
        return class_2561.method_43471((String)("hexcasting.iota." + key)).method_27694(style -> style.method_27703(class_5251.method_27717((int)this.color())));
    }

    public static class_2487 serialize(Iota iota) {
        IotaType<?> type = iota.getType();
        class_2960 typeId = HexIotaTypes.REGISTRY.method_10221(type);
        if (typeId == null) {
            throw new IllegalStateException("Tried to serialize an unregistered iota type. Iota: " + iota + " ; Type" + type.getClass().getTypeName());
        }
        if (IotaType.isTooLargeToSerialize(List.of(iota), 0)) {
            return IotaType.serialize(new GarbageIota());
        }
        class_2520 dataTag = iota.serialize();
        class_2487 out = new class_2487();
        out.method_10582("hexcasting:type", typeId.toString());
        out.method_10566("hexcasting:data", dataTag);
        return out;
    }

    public static boolean isTooLargeToSerialize(Iterable<Iota> examinee) {
        return IotaType.isTooLargeToSerialize(examinee, 1);
    }

    private static boolean isTooLargeToSerialize(Iterable<Iota> examinee, int startingCount) {
        int totalSize = startingCount;
        for (Iota iota : examinee) {
            if (iota.depth() >= 256) {
                return true;
            }
            totalSize += iota.size();
        }
        return totalSize >= 1024;
    }

    @Nullable
    public static IotaType<?> getTypeFromTag(class_2487 tag) {
        if (!tag.method_10573("hexcasting:type", 8)) {
            return null;
        }
        String typeKey = tag.method_10558("hexcasting:type");
        if (!class_2960.method_20207((String)typeKey)) {
            return null;
        }
        class_2960 typeLoc = new class_2960(typeKey);
        return (IotaType)HexIotaTypes.REGISTRY.method_10223(typeLoc);
    }

    public static Iota deserialize(class_2487 tag, class_3218 world) {
        Iota deserialized;
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return new GarbageIota();
        }
        class_2520 data = tag.method_10580("hexcasting:data");
        if (data == null) {
            return new GarbageIota();
        }
        try {
            deserialized = Objects.requireNonNullElse(type.deserialize(data, world), new NullIota());
        }
        catch (IllegalArgumentException exn) {
            HexAPI.LOGGER.warn("Caught an exception deserializing an iota", (Throwable)exn);
            deserialized = new GarbageIota();
        }
        return deserialized;
    }

    private static class_2561 brokenIota() {
        return class_2561.method_43471((String)"hexcasting.spelldata.unknown").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    }

    public static class_2561 getDisplay(class_2487 tag) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return IotaType.brokenIota();
        }
        class_2520 data = tag.method_10580("hexcasting:data");
        if (data == null) {
            return IotaType.brokenIota();
        }
        return type.display(data);
    }

    public static class_5481 getDisplayWithMaxWidth(class_2487 tag, int maxWidth, class_327 font) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return IotaType.brokenIota().method_30937();
        }
        class_2520 data = tag.method_10580("hexcasting:data");
        if (data == null) {
            return IotaType.brokenIota().method_30937();
        }
        class_2561 display = type.display(data);
        List splitted = font.method_1728((class_5348)display, maxWidth - font.method_1727("..."));
        if (splitted.isEmpty()) {
            return class_5481.field_26385;
        }
        if (splitted.size() == 1) {
            return (class_5481)splitted.get(0);
        }
        class_5481 first = (class_5481)splitted.get(0);
        return class_5481.method_30752((class_5481)first, (class_5481)class_2561.method_43470((String)"...").method_27692(class_124.field_1080).method_30937());
    }

    public static int getColor(class_2487 tag) {
        IotaType<?> type = IotaType.getTypeFromTag(tag);
        if (type == null) {
            return -524040;
        }
        return type.color();
    }
}

